/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Workfile: BaseDialog.cpp $
   Last Modification:
    $Author: MichaelT $
    $Modtime: 29.06.06 16:02 $
    $Revision: 436 $
   
   Targets:
     Win32/ANSI   : yes
     Win32/Unicode: yes (define _UNICODE)
     WinCE        : no
 
   Description:
       
   Changes:
    Base dialog for all pages. Overrides PreTranslateMessage to prevent closing by keypress
    and creates a cyclic thread if neccessary
 
     Version   Date        Author   Description
     ----------------------------------------------------------------------------------
      1        29.06.2006  MT       initial version
 
**************************************************************************************/

///////////////////////////////////////////////////////////////////////////////////////////
///  \file BaseDialog.cpp
///   Base dialog for all pages. Overrides PreTranslateMessage to prevent closing by keypress
///   and creates a cyclic thread if neccessary
///////////////////////////////////////////////////////////////////////////////////////////

#include "StdAfx.h"
#include ".\basedialog.h"

IMPLEMENT_DYNAMIC(CBaseDialog, CDialog)

/////////////////////////////////////////////////////////////////////////////
/// Default Constructor
///   \param uiIDD            Dialog resource ID
///   \param pcParent         Parent window
///   \param fEnableThread    true if a thread should be created
///   \param ulThreadTimeout  Starting timeout value for thread (default = 10ms)
/////////////////////////////////////////////////////////////////////////////
CBaseDialog::CBaseDialog(UINT uiIDD, CWnd* pcParent, bool fEnableThread, unsigned long ulThreadTimeout)
: CDialog(uiIDD, pcParent)
, m_fCreateThread(fEnableThread)
, m_ulThreadTimeout(ulThreadTimeout)
, m_fThreadActive(false)
{
}

/////////////////////////////////////////////////////////////////////////////
/// Destructor
/////////////////////////////////////////////////////////////////////////////
CBaseDialog::~CBaseDialog(void)
{
  if(m_fCreateThread)
  {
    SetEvent(m_hThreadStop);
    if(WaitForSingleObject(m_hCyclicThread, 1000) == WAIT_TIMEOUT)
      ::TerminateThread(m_hCyclicThread, MAXDWORD);

    CloseHandle(m_hThreadStop);
  }
}

BEGIN_MESSAGE_MAP(CBaseDialog, CDialog)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
/// Filter messages to prevent dialog closing by keypress
/// (WM_KEYDOWN combined with VK_RETURN/VK_ESCAPE) will be filtered
///  \param pMsg Message to be checked for filtering
///  \return TRUE if the message should be filtered 
/////////////////////////////////////////////////////////////////////////////
BOOL CBaseDialog::PreTranslateMessage(MSG* pMsg)
{
  if(pMsg->message == WM_KEYDOWN)
  {
    if( (pMsg->wParam == VK_RETURN) ||
        (pMsg->wParam == VK_ESCAPE) )
    {
      return TRUE;
    }
  }

  return CDialog::PreTranslateMessage(pMsg);
}

/////////////////////////////////////////////////////////////////////////////
/// Thread handling cylic options
///  \param pcParm Pointer to the class, the thread is belonging to
///  \return 0
/////////////////////////////////////////////////////////////////////////////
DWORD CBaseDialog::CyclicThreadStub(LPVOID pvParam)
{
  CBaseDialog* pcDlg = reinterpret_cast<CBaseDialog*>(pvParam);
  pcDlg->CyclicThread();

  return 0;
}

/////////////////////////////////////////////////////////////////////////////
/// Class function handling all cyclic events
/////////////////////////////////////////////////////////////////////////////
void CBaseDialog::CyclicThread()
{
  while(WaitForSingleObject(m_hThreadStop, m_ulThreadTimeout) == WAIT_TIMEOUT)
  {
    if(m_fThreadActive)
    {
      ThreadFunction();
    }
  }
}

/////////////////////////////////////////////////////////////////////////////
/// First Time Dialog initialization. Creates Cylic Thread is needed
/////////////////////////////////////////////////////////////////////////////
BOOL CBaseDialog::OnInitDialog()
{
  CDialog::OnInitDialog();

  if(m_fCreateThread)
  {
    m_hThreadStop = ::CreateEvent(NULL, FALSE, FALSE, NULL);
    m_hCyclicThread = ::CreateThread(NULL,
                                     0,
                                     CyclicThreadStub,
                                     this,
                                     0, NULL);
  }

  return TRUE;  // return TRUE unless you set the focus to a control
  // EXCEPTION: OCX Property Pages should return FALSE
}
